/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.JSTypeConstants;
import com.aptana.js.core.model.ClassElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.ParameterElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.ReturnTypeElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSDeclarationNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetElementNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSNameValuePairNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSThisNode;
import com.aptana.js.internal.core.parsing.sdoc.model.DocumentationBlock;
import com.aptana.js.internal.core.parsing.sdoc.model.ExampleTag;
import com.aptana.js.internal.core.parsing.sdoc.model.ParamTag;
import com.aptana.js.internal.core.parsing.sdoc.model.ReturnTag;
import com.aptana.js.internal.core.parsing.sdoc.model.Tag;
import com.aptana.js.internal.core.parsing.sdoc.model.TagType;
import com.aptana.js.internal.core.parsing.sdoc.model.Type;
import com.aptana.js.internal.core.parsing.sdoc.model.TypeTag;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTypeUtil {
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("[\\$a-zA-Z\\-_]+[\\.\\w\\$\\-/<>]*");
    private static final Set<String> FILTERED_TYPES = CollectionsUtil.newSet((Object[])new String[]{"Array", "Boolean", "Function", "Number", "Object", "RegExp", "String", "undefined", "void", "Window", "window"});

    public static void applyDocumentation(FunctionElement function, JSNode node, DocumentationBlock block) {
        if (block != null) {
            function.setDescription(block.getText());
            if (block.hasTag(TagType.PARAM)) {
                for (Tag tag : block.getTags(TagType.PARAM)) {
                    ParamTag paramTag = (ParamTag)tag;
                    ParameterElement parameter = new ParameterElement();
                    parameter.setName(paramTag.getName());
                    parameter.setDescription(paramTag.getText());
                    parameter.setUsage(paramTag.getUsage().getName());
                    for (Type type : paramTag.getTypes()) {
                        parameter.addType(type.toSource());
                    }
                    function.addParameter(parameter);
                }
            } else if (node instanceof JSFunctionNode) {
                JSFunctionNode functionNode = (JSFunctionNode)node;
                for (IParseNode parameterNode : functionNode.getParameters()) {
                    ParameterElement parameterElement = new ParameterElement();
                    parameterElement.setName(parameterNode.getText());
                    parameterElement.addType("Object");
                    function.addParameter(parameterElement);
                }
            } else {
                String message = MessageFormat.format("Expected JSFunction node when applying documentation; however, the node type was ''{0}'' instead. Source ={1}{2}", new Object[]{node != null ? ((Object)((Object)node)).getClass().getName() : "null", FileUtil.NEW_LINE, node});
                IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (String)message);
            }
            for (Tag tag : block.getTags(TagType.RETURN)) {
                ReturnTag returnTag = (ReturnTag)tag;
                for (Type type : returnTag.getTypes()) {
                    ReturnTypeElement returnType = new ReturnTypeElement();
                    returnType.setType(type.toSource());
                    returnType.setDescription(returnTag.getText());
                    function.addReturnType(returnType);
                }
            }
            for (Tag tag : block.getTags(TagType.EXAMPLE)) {
                ExampleTag exampleTag = (ExampleTag)tag;
                function.addExample(exampleTag.getText());
            }
        }
    }

    public static void applyDocumentation(PropertyElement property, JSNode node, DocumentationBlock block) {
        if (property instanceof FunctionElement) {
            JSTypeUtil.applyDocumentation((FunctionElement)property, node, block);
        } else if (block != null) {
            property.setDescription(block.getText());
            for (Tag tag : block.getTags(TagType.TYPE)) {
                TypeTag typeTag = (TypeTag)tag;
                for (Type type : typeTag.getTypes()) {
                    ReturnTypeElement returnType = new ReturnTypeElement();
                    returnType.setType(type.toSource());
                    returnType.setDescription(typeTag.getText());
                    property.addType(returnType);
                }
            }
            for (Tag tag : block.getTags(TagType.EXAMPLE)) {
                ExampleTag exampleTag = (ExampleTag)tag;
                property.addExample(exampleTag.getText());
            }
        }
    }

    public static void applySignature(PropertyElement property, String typeName) {
        if (property instanceof FunctionElement) {
            JSTypeUtil.applySignature((FunctionElement)property, typeName);
        } else {
            property.addType(typeName);
        }
    }

    public static void applySignature(FunctionElement function, String typeName) {
        int index;
        if (function != null && typeName != null && (index = JSTypeUtil.findFunctionType(typeName)) != -1) {
            String types = typeName.substring(0, index);
            String[] stringArray = types.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (type.length() > 0) {
                    function.addType(type);
                }
                ++n2;
            }
            function.addType("Function");
            String functionWithReturnTypes = typeName.substring(index);
            for (String returnType : JSTypeUtil.getFunctionSignatureReturnTypeNames(functionWithReturnTypes)) {
                function.addReturnType(returnType);
            }
        }
    }

    private static int findFunctionType(String typeName) {
        int index = -1;
        do {
            if ((index = typeName.indexOf("Function", index + 1)) != -1) continue;
            return -1;
        } while (JSTypeUtil.getStack(typeName, '<', '>', index) != 0);
        return index;
    }

    private static int getStack(String string, char open, char close, int offset) {
        int stack = 0;
        int end = Math.min(offset, string.length());
        int i = 0;
        while (i < end) {
            char c = string.charAt(i);
            if (c == open) {
                ++stack;
            } else if (c == close) {
                --stack;
            }
            ++i;
        }
        return stack;
    }

    public static String createGenericArrayType(String elementType) {
        return "Array<" + elementType + ">";
    }

    public static String getArrayElementType(String type) {
        String result = null;
        if (type != null && type.length() > 0) {
            if (type.endsWith("[]")) {
                result = type.substring(0, type.length() - 2);
            } else if (type.startsWith("Array<") && type.endsWith(">")) {
                result = type.substring("Array<".length(), type.length() - 1);
            } else if (type.equals("Array")) {
                result = "Object";
            }
        }
        return result;
    }

    public static String getClassType(String typeName) {
        String result = null;
        if (JSTypeUtil.isClassType(typeName)) {
            result = typeName.substring("Class<".length(), typeName.length() - ">".length());
        }
        return result;
    }

    public static String toClassType(String typeName) {
        return "Class<" + typeName + ">";
    }

    public static List<String> getFunctionSignatureReturnTypeNames(String typeName) {
        if (typeName != null && typeName.startsWith("Function<")) {
            int startingIndex = "Function<".length();
            int endingIndex = typeName.lastIndexOf(">");
            if (endingIndex != -1) {
                String returnTypes = typeName.substring(startingIndex, endingIndex);
                if (returnTypes.indexOf(44) == -1) {
                    return CollectionsUtil.newList((Object[])new String[]{returnTypes});
                }
                ArrayList<String> returnTypeNames = new ArrayList<String>();
                int length = returnTypes.length();
                int pointer = 0;
                int stack = 0;
                int i = 0;
                while (i < length) {
                    char c = returnTypes.charAt(i);
                    switch (c) {
                        case '<': {
                            ++stack;
                            break;
                        }
                        case '>': {
                            --stack;
                            break;
                        }
                        case ',': {
                            if (stack != 0) break;
                            returnTypeNames.add(returnTypes.substring(pointer, i));
                            pointer = i + 1;
                            break;
                        }
                    }
                    ++i;
                }
                returnTypeNames.add(returnTypes.substring(pointer));
                return returnTypeNames;
            }
        }
        return Collections.emptyList();
    }

    public static String validateTypeName(String type) {
        if (StringUtil.isEmpty((String)type)) {
            IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (Throwable)new IllegalArgumentException("Null or Empty type name attempting to be recorded for a return type."));
            return "";
        }
        int genericOpenIndex = type.indexOf(60);
        if (genericOpenIndex != -1) {
            if (type.charAt(type.length() - 1) != '>') {
                String baseType = type.substring(0, genericOpenIndex);
                IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (Throwable)new IllegalArgumentException(MessageFormat.format("{0} type missing end '>'", baseType)));
                return baseType;
            }
        } else if (!TYPE_NAME_PATTERN.matcher(type).matches()) {
            if (type.endsWith("[]")) {
                return JSTypeUtil.validateTypeName(JSTypeUtil.createGenericArrayType(JSTypeUtil.getArrayElementType(type)));
            }
            IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (Throwable)new IllegalArgumentException(MessageFormat.format("Bad type name being set, something is going haywire: ''{0}''", type)));
            int index = type.indexOf(44);
            if (index != -1) {
                return type.substring(0, index);
            }
            return "";
        }
        return type;
    }

    public static String getName(JSNode node) {
        String result = null;
        if (node != null) {
            ArrayList<String> parts = new ArrayList<String>();
            JSNode current = node;
            while (current != null) {
                switch (current.getNodeType()) {
                    case 19: {
                        parts.add(current.getText());
                        break;
                    }
                    case 70: {
                        JSFunctionNode function = (JSFunctionNode)current;
                        IParseNode functionName = function.getName();
                        if (functionName.isEmpty()) break;
                        parts.add(functionName.getText());
                        break;
                    }
                    case 76: {
                        JSNameValuePairNode entry = (JSNameValuePairNode)current;
                        IParseNode entryName = entry.getName();
                        String name = entryName.getText();
                        if (entryName.getNodeType() == 17) {
                            name = name.substring(1, name.length() - 1);
                        }
                        parts.add(name);
                        break;
                    }
                    case 63: {
                        JSDeclarationNode declaration = (JSDeclarationNode)current;
                        IParseNode declarationName = declaration.getIdentifier();
                        parts.add(declarationName.getText());
                        break;
                    }
                    case 1: {
                        JSGetPropertyNode getProp;
                        JSAssignmentNode assignment = (JSAssignmentNode)current;
                        IParseNode lhs = assignment.getLeftHandSide();
                        if (lhs instanceof JSIdentifierNode) {
                            parts.add(lhs.getText());
                            break;
                        }
                        if (lhs instanceof JSGetPropertyNode) {
                            JSGetPropertyNode getProp2 = (JSGetPropertyNode)lhs;
                            if (!(getProp2.getChild(0) instanceof JSThisNode)) break;
                            parts.add(getProp2.getChild(1).getText());
                            break;
                        }
                        if (!(lhs instanceof JSGetElementNode)) break;
                        JSGetElementNode getElement = (JSGetElementNode)lhs;
                        parts.add(StringUtil.stripQuotes((String)getElement.getChild(1).getText()));
                        IParseNode left = getElement.getFirstChild();
                        if (!(left instanceof JSGetPropertyNode) || !((getProp = (JSGetPropertyNode)left).getChild(0) instanceof JSThisNode)) break;
                        parts.add(getProp.getChild(1).getText());
                        break;
                    }
                }
                IParseNode parent = current.getParent();
                JSNode jSNode = current = parent instanceof JSNode ? (JSNode)parent : null;
            }
            if (parts.size() > 0) {
                Collections.reverse(parts);
                result = StringUtil.join((String)".", parts);
            }
        }
        if (FILTERED_TYPES.contains(result)) {
            result = null;
        }
        return result;
    }

    public static String getUniqueTypeName() {
        return "-dynamic-type-" + UUID.randomUUID();
    }

    public static String getUniqueTypeName(String string) {
        if (string == null) {
            return "$module_" + UUID.randomUUID();
        }
        return "$module_" + UUID.nameUUIDFromBytes(string.getBytes());
    }

    public static boolean isClassType(String typeName) {
        return typeName != null && typeName.startsWith("Class<") && typeName.endsWith(">");
    }

    public static boolean isFunctionPrefix(String type) {
        boolean result = false;
        if (type != null) {
            Matcher m = JSTypeConstants.FUNCTION_PREFIX.matcher(type);
            result = m.find();
        }
        return result;
    }

    public static String toFunctionType(Collection<String> returnTypes) {
        if (CollectionsUtil.isEmpty(returnTypes)) {
            return "Function";
        }
        return "Function<" + StringUtil.join((String)",", returnTypes) + ">";
    }

    public static String toFunctionType(String type) {
        if (type == null || type.length() == 0) {
            return "Function";
        }
        return "Function<" + type + ">";
    }

    public static List<ClassElement> typesToClasses(Collection<TypeElement> types) {
        ArrayList<ClassElement> classes = new ArrayList<ClassElement>();
        if (types != null) {
            HashMap<String, ClassElement> classesByName = new HashMap<String, ClassElement>();
            for (TypeElement type : types) {
                ClassElement clss;
                String baseName;
                String typeName = type.getName();
                boolean isClassType = JSTypeUtil.isClassType(typeName);
                String string = baseName = isClassType ? JSTypeUtil.getClassType(type.getName()) : typeName;
                if (!classesByName.containsKey(baseName)) {
                    clss = new ClassElement();
                    clss.setName(baseName);
                    classesByName.put(baseName, clss);
                }
                clss = (ClassElement)classesByName.get(baseName);
                if (isClassType) {
                    clss.addClassType(type);
                    continue;
                }
                clss.addInstanceType(type);
            }
            classes = new ArrayList(classesByName.values());
        }
        return classes;
    }

    private JSTypeUtil() {
    }

    public static String getGlobalType(IProject project, String fileName) {
        IContentType type;
        if (!(fileName == null || (type = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.js")).isAssociatedWith(fileName) || fileName.endsWith("jsca") || fileName.endsWith("json") || fileName.endsWith("sdocml"))) {
            return "Window";
        }
        if (project != null) {
            try {
                String[] natureIds = project.getDescription().getNatureIds();
                String matchingNature = (String)CollectionsUtil.find(Arrays.asList(natureIds), (IFilter)new IFilter<String>(){

                    public boolean include(String item) {
                        return item.startsWith("com.appcelerator.");
                    }
                });
                if (matchingNature != null) {
                    return "Global";
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JSCorePlugin.getDefault(), (String)"Failed to get project description", (Throwable)e, null);
            }
        }
        return "Window";
    }

    public static TypeElement createGlobalType(String globalTypeName) {
        TypeElement window = new TypeElement();
        window.setName(globalTypeName);
        if ("Window".equals(globalTypeName)) {
            window.addParentType("Global");
        }
        return window;
    }
}

